/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jei;

import com.voxelutopia.ultramarine.data.recipe.ChiselTableRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ChiselTableRecipeCategory
implements IRecipeCategory<ChiselTableRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ultramarine", "chisel_table");
    public static final RecipeType<ChiselTableRecipe> CHISEL_TABLE_RECIPE_TYPE = new RecipeType(UID, ChiselTableRecipe.class);
    public static final ResourceLocation TEXTURE_GUI = new ResourceLocation("ultramarine", "textures/gui/chisel_table.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public ChiselTableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE_GUI, 25, 24, 126, 45);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.CHISEL_TABLE.get()));
        this.localizedName = Component.m_237115_((String)"gui.jei.category.chisel_table");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChiselTableRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getMaterial());
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 1).addIngredients(recipe.getTemplate());
        List<Ingredient> colors = recipe.getColors();
        for (int i = 0; i < colors.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + 18 * i, 28).addIngredients(colors.get(i));
        }
        if (Minecraft.m_91087_().f_91073_ != null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 10).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        }
    }

    public void draw(ChiselTableRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public RecipeType<ChiselTableRecipe> getRecipeType() {
        return CHISEL_TABLE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

